/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.toolkit.runtime.resources.VWResource;
import java.text.DateFormat;
import java.util.Date;

public class VWDuration {
    protected final int SECS_PER_MIN = 60;
    protected final int MINS_PER_HOUR = 60;
    protected final int HOURS_PER_DAY = 24;
    protected final int SECS_PER_HOUR = 3600;
    protected final int SECS_PER_DAY = 86400;
    private long m_duration = 0L;

    public VWDuration() {
        this.m_duration = 0L;
    }

    public VWDuration(long duration) {
        this.m_duration = duration * 1000L;
    }

    public VWDuration(Date from, Date to) {
        this.m_duration = to.getTime() - from.getTime();
    }

    public String toString() {
        long temp;
        long hours;
        String dayString = "";
        String hourString = "";
        String minuteString = "";
        String secondString = "";
        String zeroString = Integer.toString(0);
        Object[] durationStrings = new String[]{dayString, hourString, minuteString, secondString};
        long duration = this.m_duration / 1000L;
        long days = duration / 86400L;
        if (days != 0L) {
            String string = Long.toString(days);
            dayString = days <= 1L ? VWResource.s_day.toString(string) : VWResource.s_days.toString(string);
        }
        if ((hours = (temp = duration % 86400L) / 3600L) >= 0L && hours < 10L) {
            hourString = hourString + zeroString;
        }
        hourString = hourString + Long.toString(hours);
        temp = duration % 3600L;
        long minutes = temp / 60L;
        if (minutes >= 0L && minutes < 10L) {
            minuteString = minuteString + zeroString;
        }
        minuteString = minuteString + Long.toString(minutes);
        long seconds = duration % 60L;
        if (seconds >= 0L && seconds < 10L) {
            secondString = secondString + zeroString;
        }
        secondString = secondString + Long.toString(seconds);
        durationStrings[0] = dayString;
        durationStrings[1] = hourString;
        durationStrings[2] = minuteString;
        durationStrings[3] = secondString;
        String str = VWResource.s_duration.toString(durationStrings);
        return str;
    }

    public void setDuration(Date from, Date to) {
        DateFormat dateTimeFormatter = DateFormat.getDateTimeInstance(2, 2);
        if (to == null) {
            this.setDuration(from);
        } else {
            long fromTime = from.getTime();
            long toTime = to.getTime();
            this.m_duration = toTime - fromTime;
        }
    }

    public void setDuration(Date from) {
        long fromTime = from.getTime();
        long toTime = System.currentTimeMillis();
        this.m_duration = toTime - fromTime;
    }
}

